<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    http_response_code(403);
    echo json_encode(['error' => 'Acesso não autorizado']);
    exit;
}

require_once 'db_config.php';

$doctor_id = $_SESSION['doctor_id'];
$startDateStr = $_GET['startDate'] ?? '';
$endDateStr = $_GET['endDate'] ?? '';
$compare = $_GET['compare'] ?? 'false';

// Função auxiliar para buscar dados
function fetchData($conn, $doctorId, $start, $end) {
    $sql = "SELECT * FROM organico WHERE doctor_id = ?";
    $params = [$doctorId];
    $types = 'i';

    if (!empty($start) && !empty($end)) {
        $sql .= " AND data BETWEEN ? AND ?";
        $params[] = $start;
        $params[] = $end;
        $types .= 'ss';
    }
    $sql .= " ORDER BY data DESC";

    $stmt = $conn->prepare($sql);
    if (!$stmt) return [];
    
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $data = [];
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
    $stmt->close();
    return $data;
}

// 1. Busca Período Atual
$currentData = fetchData($conn, $doctor_id, $startDateStr, $endDateStr);

// 2. Busca Período Anterior (Se Comparação estiver ativa)
$previousData = [];

if ($compare === 'true' && !empty($startDateStr) && !empty($endDateStr)) {
    try {
        $startDate = new DateTime($startDateStr);
        $endDate = new DateTime($endDateStr);
        
        $diff = $endDate->diff($startDate);
        $daysInterval = $diff->days;

        // EndB = StartA - 1 dia
        $prevEndDate = clone $startDate;
        $prevEndDate->modify('-1 day');
        
        // StartB = EndB - duração
        $prevStartDate = clone $prevEndDate;
        $prevStartDate->modify("-{$daysInterval} days");

        $prevStartStr = $prevStartDate->format('Y-m-d');
        $prevEndStr = $prevEndDate->format('Y-m-d');

        $previousData = fetchData($conn, $doctor_id, $prevStartStr, $prevEndStr);
    } catch (Exception $e) {
        // Ignora
    }
}

echo json_encode([
    'current' => $currentData,
    'previous' => $previousData
]);

$conn->close();
?>