<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    http_response_code(403);
    echo json_encode(['error' => 'Acesso não autorizado']);
    exit;
}

require_once 'db_config.php';

$doctor_id = $_SESSION['doctor_id'];

// Novos parâmetros vindos do JS
$startDateStr = $_GET['startDate'] ?? '';
$endDateStr = $_GET['endDate'] ?? '';
$rangeKey = $_GET['range'] ?? 'this_month';
$compare = $_GET['compare'] ?? 'false';

// Função auxiliar para buscar dados
function fetchData($conn, $table, $doctorId, $start, $end) {
    $params = [$doctorId];
    $types = 'i';
    
    // --- CORREÇÃO AQUI ---
    // Seu banco de dados mostra que a coluna na tabela leads se chama 'data'.
    // Portanto, não precisamos trocar para 'data_insercao'. Padronizamos tudo como 'data'.
    $dateColumn = 'data'; 
    
    $sql = "SELECT * FROM {$table} WHERE doctor_id = ?";

    if (!empty($start) && !empty($end)) {
        $sql .= " AND {$dateColumn} BETWEEN ? AND ?";
        $params[] = $start;
        $params[] = $end;
        $types .= 'ss';
    }
    $sql .= " ORDER BY {$dateColumn} DESC";

    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        return ['error' => 'SQL Prepare failed: ' . $conn->error];
    }
    $stmt->bind_param($types, ...$params);
    $stmt->execute();
    $result = $stmt->get_result();
    $data = [];
    while ($row = $result->fetch_assoc()) {
        $data[] = $row;
    }
    $stmt->close();
    return $data;
}

// Função para buscar todos os dados de um período
function fetchAllDataForPeriod($conn, $doctorId, $start, $end) {
    return [
        'leads' => fetchData($conn, 'leads', $doctorId, $start, $end),
        'trafego' => fetchData($conn, 'trafegoPago', $doctorId, $start, $end),
        'organico' => fetchData($conn, 'organico', $doctorId, $start, $end)
    ];
}

// =================================================================
// LÓGICA DE COMPARAÇÃO DE PERÍODO
// =================================================================

$prevStartDateStr = '';
$prevEndDateStr = '';

if ($compare === 'true' && !empty($startDateStr) && !empty($endDateStr)) {
    try {
        $startDate = new DateTime($startDateStr);
        $endDate = new DateTime($endDateStr);
        
        $diff = $endDate->diff($startDate);
        $daysInterval = $diff->days;

        $prevEndDate = clone $startDate;
        $prevEndDate->modify('-1 day');
        
        $prevStartDate = clone $prevEndDate;
        $prevStartDate->modify("-{$daysInterval} days");

        $prevStartDateStr = $prevStartDate->format('Y-m-d');
        $prevEndDateStr = $prevEndDate->format('Y-m-d');

    } catch (Exception $e) {
        // Ignora datas inválidas
    }
}

$currentData = fetchAllDataForPeriod($conn, $doctor_id, $startDateStr, $endDateStr);

$previousData = [
    'leads' => [],
    'trafego' => [],
    'organico' => []
];

if ($compare === 'true' && !empty($prevStartDateStr) && !empty($prevEndDateStr)) {
    $previousData = fetchAllDataForPeriod($conn, $doctor_id, $prevStartDateStr, $prevEndDateStr);
}

$response = [
    'current' => $currentData,
    'previous' => $previousData
];

echo json_encode($response);

$conn->close();
?>