document.addEventListener('DOMContentLoaded', () => {
    // --- EFEITO 3D (TILT) ---
    const loginCard = document.getElementById('loginCard');
    if (loginCard) {
        document.addEventListener('mousemove', (e) => {
            const { clientX, clientY } = e;
            const { innerWidth, innerHeight } = window;
            const xRotation = (clientY / innerHeight - 0.5) * 10;
            const yRotation = -(clientX / innerWidth - 0.5) * 10;
            loginCard.style.transform = `rotateX(${xRotation}deg) rotateY(${yRotation}deg)`;
        });
        document.addEventListener('mouseleave', () => {
             loginCard.style.transform = `rotateX(0deg) rotateY(0deg)`;
        });
    }

    // --- SISTEMA DE PARTCULAS HBRIDO (AURORA + CONNECT) ---
    const canvas = document.getElementById('particle-canvas');
    if (canvas) {
        const ctx = canvas.getContext('2d');
        canvas.width = window.innerWidth;
        canvas.height = window.innerHeight;
        let particlesArray;

        const mouse = { x: null, y: null, radius: 100 };
        window.addEventListener('mousemove', (event) => {
            mouse.x = event.x;
            mouse.y = event.y;
        });
         window.addEventListener('mouseout', () => {
            mouse.x = undefined;
            mouse.y = undefined;
        });

        class Particle {
            constructor(x, y, dX, dY, size, color) {
                this.x = x; this.y = y; this.directionX = dX; this.directionY = dY; this.size = size; this.color = color;
            }
            draw() {
                ctx.beginPath();
                ctx.arc(this.x, this.y, this.size, 0, Math.PI * 2, false);
                ctx.fillStyle = this.color;
                ctx.fill();
            }
            update() {
                if (this.x > canvas.width || this.x < 0) this.directionX = -this.directionX;
                if (this.y > canvas.height || this.y < 0) this.directionY = -this.directionY;
                
                // INTERAO DE REPULSA (EFEITO AURORA)
                if (mouse.x !== undefined && mouse.y !== undefined) {
                    let dx = mouse.x - this.x; 
                    let dy = mouse.y - this.y;
                    let distance = Math.sqrt(dx * dx + dy * dy);
                    if (distance < mouse.radius + this.size) {
                        if (mouse.x < this.x && this.x < canvas.width - this.size * 10) this.x += 3;
                        if (mouse.x > this.x && this.x > this.size * 10) this.x -= 3;
                        if (mouse.y < this.y && this.y < canvas.height - this.size * 10) this.y += 3;
                        if (mouse.y > this.y && this.y > this.size * 10) this.y -= 3;
                    }
                }

                this.x += this.directionX; this.y += this.directionY; this.draw();
            }
        }

        function init() {
            particlesArray = [];
            let num = (canvas.height * canvas.width) / 9000;
            for (let i = 0; i < num; i++) {
                let size = (Math.random() * 2) + 1;
                let x = (Math.random() * ((innerWidth - size * 2) - (size * 2)) + size * 2);
                let y = (Math.random() * ((innerHeight - size * 2) - (size * 2)) + size * 2);
                let dX = (Math.random() * .4) - .2; 
                let dY = (Math.random() * .4) - .2;
                let color = 'rgba(125, 85, 255, 0.6)';
                particlesArray.push(new Particle(x, y, dX, dY, size, color));
            }
        }

        // FUNO PARA CONECTAR PARTCULAS (DO SEU PAINEL ORIGINAL)
        function connect() {
            let opacityValue = 1;
            for (let a = 0; a < particlesArray.length; a++) {
                for (let b = a; b < particlesArray.length; b++) {
                    let distance = ((particlesArray[a].x - particlesArray[b].x) * (particlesArray[a].x - particlesArray[b].x)) +
                        ((particlesArray[a].y - particlesArray[b].y) * (particlesArray[a].y - particlesArray[b].y));
                    if (distance < (canvas.width / 8) * (canvas.height / 8)) {
                        opacityValue = 1 - (distance / 20000);
                        ctx.strokeStyle = `rgba(125, 85, 255, ${opacityValue})`;
                        ctx.lineWidth = 1;
                        ctx.beginPath();
                        ctx.moveTo(particlesArray[a].x, particlesArray[a].y);
                        ctx.lineTo(particlesArray[b].x, particlesArray[b].y);
                        ctx.stroke();
                    }
                }
            }
        }

        function animate() {
            requestAnimationFrame(animate);
            ctx.clearRect(0, 0, innerWidth, innerHeight);
            for (let i = 0; i < particlesArray.length; i++) {
                particlesArray[i].update();
            }
            connect(); // Chamando a funo de conectar
        }
        
        init(); 
        animate();

        window.addEventListener('resize', () => { 
            canvas.width = innerWidth; 
            canvas.height = innerHeight; 
            mouse.radius = 100;
            init(); 
        });
    }

    // --- LGICA DE LOGIN INTEGRADA ---
    const loginForm = document.getElementById('loginForm');
    if (loginForm) {
        const usernameField = document.getElementById('username');
        const passwordField = document.getElementById('password');
        const errorMessage = document.getElementById('errorMessage');
        const loginButton = document.getElementById('loginButton');

        const validateField = (field) => {
            const parent = field.parentElement;
            const icon = parent.querySelector('.fas');
            if (field.value.trim() !== '') {
                parent.dataset.status = 'valid';
                icon.className = 'fas fa-check-circle';
                return true;
            } else {
                parent.dataset.status = 'invalid';
                icon.className = 'fas fa-exclamation-circle';
                return false;
            }
        };

        usernameField.addEventListener('blur', () => validateField(usernameField));
        passwordField.addEventListener('blur', () => validateField(passwordField));
        
        loginForm.addEventListener('submit', async function(e) {
            e.preventDefault();
            errorMessage.textContent = '';
            loginForm.classList.remove('error');

            const isUsernameValid = validateField(usernameField);
            const isPasswordValid = validateField(passwordField);
            if (!isUsernameValid || !isPasswordValid) {
                loginForm.classList.add('error');
                errorMessage.textContent = 'Por favor, preencha todos os campos.';
                return;
            }

            loginButton.classList.add('authenticating');
            loginButton.disabled = true;

            const formData = new FormData();
            formData.append('action', 'login');
            formData.append('username', usernameField.value);
            formData.append('password', passwordField.value);

            try {
                const response = await fetch('api/auth.php', {
                    method: 'POST',
                    body: formData
                });
                const result = await response.json();

                if (result.success) {
                    loginCard.classList.add('success');
                    setTimeout(() => {
                        window.location.href = 'dashboard.html';
                    }, 1500);
                } else {
                    errorMessage.textContent = result.message || 'Ocorreu um erro.';
                    loginForm.classList.add('error');
                    loginButton.classList.remove('authenticating');
                    loginButton.disabled = false;
                }
            } catch (error) {
                errorMessage.textContent = 'Erro de conexo com o servidor.';
                loginForm.classList.add('error');
                loginButton.classList.remove('authenticating');
                loginButton.disabled = false;
            }
        });
    }
});