<?php
session_start();
require_once 'db_config.php';

$action = $_POST['action'] ?? $_GET['action'] ?? '';

switch ($action) {
    case 'login':
        $username = $_POST['username'] ?? '';
        $password = $_POST['password'] ?? '';

        $stmt = $conn->prepare("SELECT id, name, password_hash FROM doctors WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows === 1) {
            $doctor = $result->fetch_assoc();
            if (password_verify($password, $doctor['password_hash'])) {
                $_SESSION['loggedin'] = true;
                $_SESSION['doctor_id'] = $doctor['id'];
                $_SESSION['doctor_name'] = $doctor['name'];
                echo json_encode(['success' => true]);
            } else {
                echo json_encode(['success' => false, 'message' => 'Senha incorreta.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Usuário não encontrado.']);
        }
        $stmt->close();
        break;

    case 'logout':
        session_destroy();
        echo json_encode(['success' => true]);
        break;

    case 'check_session':
        if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
            echo json_encode(['loggedin' => true, 'doctor_name' => $_SESSION['doctor_name']]);
        } else {
            echo json_encode(['loggedin' => false]);
        }
        break;

    // Para criar um médico (use isso uma vez para cadastrar)
    case 'create_doctor':
        // IMPORTANTE: Remova ou proteja esta parte após o uso!
        $name = "Doutor Exemplo";
        $username = "drx";
        $password = "senhaforte123";
        $slug = "doutor_x";
        $password_hash = password_hash($password, PASSWORD_DEFAULT);

        $stmt = $conn->prepare("INSERT INTO doctors (name, username, password_hash, slug) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("ssss", $name, $username, $password_hash, $slug);
        if($stmt->execute()){
            echo "Doutor criado com sucesso!";
        } else {
            echo "Erro: " . $stmt->error;
        }
        $stmt->close();
        break;
}

$conn->close();
?>