<?php
session_start();
header('Content-Type: application/json');

// Segurança: Se não estiver logado, encerra a execução.
if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    http_response_code(403); // Forbidden
    echo json_encode(['error' => 'Acesso não autorizado']);
    exit;
}

require_once 'db_config.php';

$doctor_id = $_SESSION['doctor_id'];
$dataType = $_GET['type'] ?? '';
$startDate = $_GET['startDate'] ?? '';
$endDate = $_GET['endDate'] ?? '';

// --- CORREÇÃO DE SEGURANÇA: Whitelist para o tipo de dado ---
// Valida explicitamente os valores permitidos para $dataType.
$tableName = '';
if ($dataType === 'metrics') {
    $tableName = 'metrics';
} elseif ($dataType === 'leads') {
    $tableName = 'leads';
} else {
    // Se o valor for qualquer outra coisa, encerra a execução.
    http_response_code(400); // Bad Request
    echo json_encode(['error' => 'Tipo de dado inválido']);
    exit;
}

// Constrói a consulta SQL de forma segura
$sql = "SELECT * FROM {$tableName} WHERE doctor_id = ?";

$params = [$doctor_id];
$types = 'i';

// A lógica de filtro por data continua, agora sendo efetivamente usada pelo front-end
if (!empty($startDate) && !empty($endDate)) {
    $sql .= " AND data BETWEEN ? AND ?";
    $params[] = $startDate;
    $params[] = $endDate;
    $types .= 'ss';
}

$sql .= " ORDER BY data DESC";

$stmt = $conn->prepare($sql);

// bind_param precisa de referências, especialmente com splat operator (...)
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}

$stmt->execute();
$result = $stmt->get_result();

$data = [];
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
}

echo json_encode($data);

$stmt->close();
$conn->close();
?>